#include <bits/stdc++.h>
#include <ext/pb_ds/assoc_container.hpp>

using namespace std;
using namespace __gnu_pbds;

#define endl "\n"
#define ll long long
#define IOS ios_base::sync_with_stdio(false); cin.tie(nullptr);

const int N = 2e5 + 5;

int a[N];
int c[N];
int sz[N];
int parent[N];
int tour[N];
bool visInit[N];
bool vis[N];
list<int> adj[N];

int segtree[4 * N];
int lazy[4 * N];
int setVal[4 * N];
bool setValid[4 * N];

int euler = 0;
int init = 1;

void compose(int parent, int child) {
    if (setValid[parent]) {
        setValid[child] = 1;
        setVal[child] = setVal[parent];
        lazy[child] = lazy[parent];
    }
}

void apply(int node, int l, int r) {
    if (setValid[node]) {
        segtree[node] = (r - l + 1) * setVal[node];
    }
    if (l != r) {
        compose(node, 2 * node + 1);
        compose(node, 2 * node + 2);
    }
    setValid[node] = false;
    lazy[node] = 0;
}

void setUpdate(int node, int l, int r, int lq, int rq, ll val) {
    if (l > rq || lq > r) {
        return;
    }
    if (l >= lq && r <= rq) {
        setValid[node] = true;
        setVal[node] = val;
        lazy[node] = 0;
        return;
    }
    apply(node, l, r);
    int mid = (l + r) / 2;
    setUpdate(node * 2 + 1, l, mid, lq, rq, val);
    setUpdate(node * 2 + 2, mid + 1, r, lq, rq, val);
    apply(2 * node + 1, l, mid);
    apply(2 * node + 2, mid + 1, r);
    segtree[node] = segtree[node * 2 + 1] + segtree[node * 2 + 2];
}

int getSum(int l, int r, int lq, int rq, int node) {
    if (l > rq || lq > r) {
        return 0;
    }
    apply(node, l, r);
    if (l >= lq && r <= rq) {
        return segtree[node];
    }
    int mid = (l + r) / 2;
    return getSum(l, mid, lq, rq, 2 * node + 1) +
           getSum(mid + 1, r, lq, rq, 2 * node + 2);
}

int get(int v, int n) {
    return getSum(0, n - 1, tour[v], tour[v], 0);
}

void build(int l, int r, int node) {
    if (l > r) {
        return;
    }
    if (l == r) {
        segtree[node] = a[l];
        return;
    }
    int mid = (l + r) / 2;
    build(l, mid, node * 2 + 1);
    build(mid + 1, r, node * 2 + 2);
    segtree[node] = segtree[node * 2 + 1] + segtree[node * 2 + 2];
}

int dfsInit(int v, int ct) {
    visInit[v] = true;
    tour[v] = euler++;
    for (auto it = adj[v].begin(); it != adj[v].end(); ++it) {
        if (!visInit[*it]) {
            if (c[*it] != c[v]) {
                init++;
            }
            parent[*it] = v;
            ct += dfsInit(*it, 1);
        }
    }
    return sz[v] = ct;
}

void dfsUpd(int v, int n) {
    vis[v] = true;
    for (auto it = adj[v].begin(); it != adj[v].end(); ++it) {
        if (parent[v] != *it) {
            if (get(*it, n) != get(v, n)) {
                init--;
            }
            if (!vis[*it]) {
                dfsUpd(*it, n);
            }
        }
    }
}



int main() {
    IOS;
    int n, q;
    cin >> n >> q;
    for (int i = 0; i < n - 1; i++) {
        int x, y;
        cin >> x >> y;
        x--, y--;
        adj[x].push_back(y);
        adj[y].push_back(x);
    }
    for (int i = 0; i < n; i++) {
        cin >> c[i];
    }

    parent[0] = -1;
    dfsInit(0, 1);

    for (int i = 0; i < n; i++)
        a[tour[i]] = c[i];

    build(0, n - 1, 0);

    for (int i = 0; i < q; i++) {
        int v, u;
        cin >> v >> u;
        v--;
        if (parent[v] != -1) {

            int cur = get(v, n);
            int par = get(parent[v], n);
            if (par == cur && u != cur) {
                init++;
            }
            if (par != cur && u == par) {
                init--;
            }
        }
        if (!vis[v]) {
            dfsUpd(v, n);
        }
        setUpdate(0, 0, n - 1, tour[v], tour[v] + sz[v] - 1, u);
        cout << init << endl;
    }



    return 0;
}